--P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL_CAPACIDADE  1,900,'20180727',0
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL_CAPACIDADE]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL_CAPACIDADE]
GO
 
IF EXISTS ( SELECT * FROM SYS.OBJECTS
		WHERE NAME ='EST_PROD_TRANSF_ANALISE_LIMIT')
BEGIN 
	DROP TABLE EST_PROD_TRANSF_ANALISE_LIMIT
END 

go
CREATE PROCEDURE [dbo].[P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL_CAPACIDADE] @CD_EMP				INT, 
																			@CD_DEPOSITO		INT, 
																			@DT_REF				DATETIME,
																			@SIMULACAO			INT=0
WITH ENCRYPTION
 AS

/*******************************************************************************************************/
	SET NOCOUNT ON;
	if @SIMULACAO > 0 
	begin
		set @SIMULACAO=1
	end


	IF NOT EXISTS(SELECT TOP 1 CD_SISTEMA
					FROM PRC_PR_SISTEMAS
					WHERE  CD_SISTEMA=30 AND HABILITADO=1)
	BEGIN
		RETURN;--Sistema nao habilitado para empresa.(modulo vendido separadamente).
	END

	--Se nao tem configuracao sai da rotina
	if @SIMULACAO = 0 
	    IF NOT EXISTS(select 1 from EST_PROD_PRT_GRP_RESSUPRIMENTO_CAPACIDADE
						  where 
							 dt_Ressup = @DT_REF
							 and CD_FILIAL_DEPOSITO =@CD_DEPOSITO 
							 and FLAG_SIMULACAO = 0)
	    BEGIN
			Print 'Abandonou a rotina de capacidade'
		    RETURN;
	    END

	declare @RegAfetado int
	
	IF EXISTS ( SELECT * FROM SYS.OBJECTS
			WHERE NAME ='EST_PROD_TRANSF_ANALISE_LIMIT')
	BEGIN 
		DROP TABLE EST_PROD_TRANSF_ANALISE_LIMIT
	END 
	CREATE TABLE EST_PROD_TRANSF_ANALISE_LIMIT(CD_EMP		INT,
												CD_FILIAL	INT,
												CD_PROD		INT,
												CD_GRP_PRT	INT, 
												QT_EST_RESSUP	MONEY,
												POSICAO			INT,
												TP_LIMITADOR	INT,
												QTDE_CX_FECHADA	MONEY,
												QTDE_FRACIONADO	MONEY,  
												SUB_TOT			MONEY,
												QT_UNI_RESSUPRIMENTO	MONEY,
												FLAG_RESSUPRIMENTO_CAIXA_FECHADA INT,
												MEDIAF			MONEY,
												QT_EST			MONEY,
												OCIOSO			INT,
												QEMAX			MONEY,
												QT_EST_CD		MONEY,
												QT_SOL_PROD		MONEY,
												RATEIO			INT)	

/*******************************************************************************************************/
	IF EXISTS ( SELECT * FROM SYS.OBJECTS
			WHERE NAME ='EST_PROD_TRANSF_IT_LIMITE')
	BEGIN 
		DROP TABLE EST_PROD_TRANSF_IT_LIMITE
	END 

	CREATE TABLE EST_PROD_TRANSF_IT_LIMITE(CD_EMP		INT,
											CD_FILIAL	INT,
											CD_PROD		INT,
											QT_EST_RESSUP	MONEY);
 	
/*******************************************************************************************************/
    UPDATE EST_PROD_TRANSF_NECESSIDADE	 
		SET	 QT_EST_RESSUP_PICKING =QT_EST_RESSUP;

/*******************************************************************************************************/
--								Capacidade do CD
/*******************************************************************************************************/

	PRINT 'Analise da capacidade do CD  '  + convert(varchar, @CD_DEPOSITO) + ' Ressup.: Dia ' + convert(varchar,@DT_REF,112) + ' - Time ' + CONVERT(VARCHAR(12), GETDATE(), 108) ;

	INSERT INTO EST_PROD_TRANSF_ANALISE_LIMIT
	SELECT 
		C.CD_EMP,
		N.CD_FILIAL,
		K.CD_PROD,
		R.CD_GRP_PRT, 
		CASE WHEN s.QT_DEPOSITO >= n.QT_EST_RESSUP THEN --Quantidade do deposito maior que o ressuprimento
							ISNULL(n.QT_EST_RESSUP,0) 
					ELSE --Quantidade do deposito menor que o ressuprimento
							ISNULL(s.QT_DEPOSITO,0)
					END QT_EST_RESSUP,
		ROW_NUMBER() OVER (PARTITION BY R.CD_GRP_PRT   ORDER BY  R.CD_GRP_PRT, CONVERT(MONEY, (N.QT_EST_LJ + N.QT_PEND_ENT_LJ/ 
									CASE WHEN N.QTDE_MEDIAF > 0 THEN N.QTDE_MEDIAF
				ELSE 0.001 END  ) *30.000) ) POSICAO,
		R.TP_LIMITADOR,
		R.QTDE_CX_FECHADA,
		R.QTDE_FRACIONADO,  
		CONVERT(MONEY, 0.00) SUB_TOT,
		n.QT_UNI_RESSUPRIMENTO,
		n.FLAG_RESSUPRIMENTO_CAIXA_FECHADA ,
		QTDE_MEDIAF,
		QT_EST_LJ+QT_PEND_ENT_LJ QT_EST,
		ISNULL(FLAG_OCIOSO,0) OC,
		ROUND(N.EMAX,0) QEMAX,
		ISNULL(s.QT_DEPOSITO,0),
		0 QTD_RESSUP_PROD,
		1 RATEIO
	FROM 
		EST_PROD_PRT_GRP_RESSUPRIMENTO G
		INNER JOIN    EST_PROD_PRT_GRP_RESSUPRIMENTO_CPL P ON
		G.CD_GRP_PRT =P.CD_GRP_PRT
		INNER JOIN  EST_PROD_CPL C ON  
		P.CD_PRT	=C.PRAT

		INNER JOIN  EST_PROD K ON  
		C.CD_EMP	= K.CD_EMP AND
		C.CD_PROD	= K.CD_PROD

		INNER JOIN EST_PROD_PRT_GRP_RESSUPRIMENTO_CAPACIDADE R on 
		G.CD_GRP_PRT = R.CD_GRP_PRT
		AND R.DT_RESSUP=@DT_REF 
		AND R.CD_FILIAL_DEPOSITO=@CD_DEPOSITO 
	--	AND (CASE WHEN @SIMULACAO =0 THEN 0  ELSE  FLAG_SIMULACAO  END) = FLAG_SIMULACAO 

		INNER JOIN EST_PROD_TRANSF_NECESSIDADE n on
		K.CD_PROD	= N.CD_PROD 
		INNER JOIN EST_PROD_TRANSF_CONSOLIDADO s ON 
		n.CD_PROD = s.CD_PROD 

	WHERE 
		C.CD_FILIAL=@CD_DEPOSITO 
		AND C.CD_EMP=@CD_EMP 
		AND (QT_EST_LJ+QT_PEND_ENT_LJ) < ROUND(N.EMAX,0) 
	--	AND R.CD_GRP_PRT=3
	ORDER BY POSICAO;
	
	  
	CREATE UNIQUE CLUSTERED INDEX IX_EST_PROD_TRANSF_ANALISE_LIMIT_CD_GRP_PRT ON 
		EST_PROD_TRANSF_ANALISE_LIMIT (FLAG_RESSUPRIMENTO_CAIXA_FECHADA,CD_GRP_PRT,CD_PROD,CD_FILIAL,CD_EMP);
	
	CREATE NONCLUSTERED INDEX IX_EST_PROD_TRANSF_ANALISE_LIMIT_CD_GRP_PRT_2
		ON [dbo].[EST_PROD_TRANSF_ANALISE_LIMIT] ([CD_GRP_PRT],[CD_EMP],[CD_PROD])
		INCLUDE ([CD_FILIAL],[QT_EST_RESSUP],[QT_UNI_RESSUPRIMENTO],[FLAG_RESSUPRIMENTO_CAIXA_FECHADA],[QT_EST],[QEMAX])

	CREATE NONCLUSTERED INDEX IX_EST_PROD_TRANSF_ANALISE_LIMIT_CD_GRP_PRT_3
		ON [dbo].[EST_PROD_TRANSF_ANALISE_LIMIT] ([CD_GRP_PRT], [POSICAO])
	
	CREATE NONCLUSTERED INDEX IX_EST_PROD_TRANSF_ANALISE_LIMIT_CD_GRP_PRT_4
		ON [dbo].[EST_PROD_TRANSF_ANALISE_LIMIT] ([CD_GRP_PRT],[RATEIO])
		INCLUDE ([CD_EMP],[CD_FILIAL],[CD_PROD],[QT_EST_RESSUP],[QT_UNI_RESSUPRIMENTO],
				    [FLAG_RESSUPRIMENTO_CAIXA_FECHADA],[QT_EST],[QEMAX],[QT_EST_CD],[QT_SOL_PROD])

	CREATE NONCLUSTERED INDEX IX_EST_PROD_TRANSF_ANALISE_LIMIT_CD_GRP_PRT_5
		ON [dbo].[EST_PROD_TRANSF_ANALISE_LIMIT] ([CD_GRP_PRT],[FLAG_RESSUPRIMENTO_CAIXA_FECHADA],[RATEIO])
		INCLUDE ([CD_EMP],[CD_FILIAL],[CD_PROD],[QT_EST_RESSUP],[MEDIAF],[QT_EST],[POSICAO]) 
	
	
/*******************************************************************************************************/
-- RATEIO LIMITADOR POR SKU
/*******************************************************************************************************/
	
	IF EXISTS (SELECT TOP 1 * 
				FROM EST_PROD_TRANSF_ANALISE_LIMIT
					where TP_LIMITADOR=0)
	BEGIN
		
		PRINT 'Realizando limite capacidade CD SKU  (' + CONVERT(VARCHAR(12), GETDATE(), 114) + ')';

		/*****************************************************************************/
		--FRACIONADO
		/*****************************************************************************/
					
		UPDATE T
		SET
			SUB_TOT= ISNULL(QTDE,0)+ QT_EST_RESSUP  
		FROM
			EST_PROD_TRANSF_ANALISE_LIMIT T
			CROSS APPLY (SELECT 
								SUM(R.QT_EST_RESSUP) QTDE
							FROM EST_PROD_TRANSF_ANALISE_LIMIT R
							WHERE 
								R.POSICAO < T.POSICAO
								AND R.CD_GRP_PRT=T.CD_GRP_PRT
								AND R.FLAG_RESSUPRIMENTO_CAIXA_FECHADA=0)P
		WHERE T.FLAG_RESSUPRIMENTO_CAIXA_FECHADA=0;

		INSERT INTO EST_PROD_TRANSF_IT_LIMITE
		SELECT 
			CD_EMP,	
			CD_FILIAL,	
			CD_PROD,	
			QT_EST_RESSUP 
		FROM EST_PROD_TRANSF_ANALISE_LIMIT
		WHERE SUB_TOT<= QTDE_FRACIONADO
		AND FLAG_RESSUPRIMENTO_CAIXA_FECHADA=0

		/*****************************************************************************/
		--CAIXA FECHADA
		/*****************************************************************************/

		UPDATE T
		SET
			SUB_TOT= ISNULL(QTDE,0)+ QT_EST_RESSUP
		FROM
			EST_PROD_TRANSF_ANALISE_LIMIT T
			CROSS APPLY (SELECT 
								SUM(R.QT_EST_RESSUP) QTDE
							FROM EST_PROD_TRANSF_ANALISE_LIMIT R
							WHERE 
								R.POSICAO < T.POSICAO
								AND R.CD_GRP_PRT=T.CD_GRP_PRT
								AND R.FLAG_RESSUPRIMENTO_CAIXA_FECHADA=1)P
		WHERE T.FLAG_RESSUPRIMENTO_CAIXA_FECHADA=1; 


		INSERT INTO EST_PROD_TRANSF_IT_LIMITE
		SELECT 
			CD_EMP,	
			CD_FILIAL,	
			CD_PROD,	
			QT_EST_RESSUP  
		FROM EST_PROD_TRANSF_ANALISE_LIMIT
		WHERE SUB_TOT<= QTDE_CX_FECHADA
		AND FLAG_RESSUPRIMENTO_CAIXA_FECHADA=1;
		
/**************************************************************************************************************************************/
/**************************************************************************************************************************************/		

		--Limita as quantidades 
		UPDATE F
		SET
			QT_EST_RESSUP= ISNULL(l.QT_EST_RESSUP,0)
		FROM
			EST_PROD_TRANSF_NECESSIDADE f 

			INNER JOIN EST_PROD_TRANSF_ANALISE_LIMIT A ON
			F.CD_FILIAL  =A.CD_FILIAL AND
			F.CD_PROD	 =A.CD_PROD 

			LEFT JOIN EST_PROD_TRANSF_IT_LIMITE L ON
			F.CD_FILIAL  =L.CD_FILIAL AND
			F.CD_PROD	 =L.CD_PROD;

/**************************************************************************************************************************************/
/**************************************************************************************************************************************/
-- Completa a capacidade ociosa do CD
/**************************************************************************************************************************************/
		
		DECLARE @CD_PRT INT,@LIMITE MONEY,@QTDE MONEY, @CORTE MONEY;

/**************************************************************************************************************************************/
--Caixa Fechada
/**************************************************************************************************************************************/
	
 		DECLARE cCapOcioso CURSOR  FAST_FORWARD READ_ONLY for
		SELECT 
			A.CD_GRP_PRT,
			A.QTDE_CX,
			B.LIM_CX 
		FROM
			(SELECT 
					CD_GRP_PRT, 
					SUM (CASE WHEN FLAG_RESSUPRIMENTO_CAIXA_FECHADA = 0 THEN 0 ELSE QT_EST_RESSUP END) QTDE_CX,
					SUM (CASE WHEN FLAG_RESSUPRIMENTO_CAIXA_FECHADA = 1 THEN 0 ELSE QT_EST_RESSUP END) QTDE_FR
				FROM 
					EST_PROD_TRANSF_ANALISE_LIMIT
				WHERE OCIOSO=1
				GROUP BY CD_GRP_PRT ) A
				INNER JOIN (SELECT 
							CD_GRP_PRT, 
							MAX(QTDE_CX_FECHADA) LIM_CX,
							MAX(QTDE_FRACIONADO) LIM_FR
						FROM 
							EST_PROD_TRANSF_ANALISE_LIMIT
						WHERE OCIOSO=1
						GROUP BY CD_GRP_PRT ) B ON
			A.CD_GRP_PRT = B.CD_GRP_PRT
		WHERE
			QTDE_CX < LIM_CX --OR QTDE_FR < LIM_FR;  

		OPEN cCapOcioso
		FETCH NEXT FROM cCapOcioso INTO @CD_PRT,@QTDE, @LIMITE

			WHILE @@FETCH_STATUS=0
			  BEGIN
				
				if @LIMITE> (SELECT 
									SUM(QT_EST_RESSUP) + @QTDE
								FROM 
									EST_PROD_TRANSF_NECESSIDADE_FUTURA
								WHERE 
									CD_GRP_PRT=@CD_PRT
									AND FLAG_RESSUPRIMENTO_CAIXA_FECHADA=1)
				begin
					--PRINT 'Implementa tudo'
					SET @CORTE=@LIMITE+1;
				END
				ELSE
				BEGIN 
					--PRINT 'Rateio' 
					SET @CORTE=@LIMITE-@QTDE;
				END
				Print 'Atualiza capacidade ociosa do CD'
				UPDATE T 
				SET
					SUB_TOTAL= ISNULL(QTDE,0)+ QT_EST_RESSUP 
				FROM
					EST_PROD_TRANSF_NECESSIDADE_FUTURA T
					CROSS APPLY (SELECT 
									SUM(R.QT_EST_RESSUP) QTDE
								FROM EST_PROD_TRANSF_NECESSIDADE_FUTURA R
								WHERE 
								R.POSICAO < T.POSICAO
								AND R.CD_GRP_PRT=T.CD_GRP_PRT
								AND R.FLAG_RESSUPRIMENTO_CAIXA_FECHADA=1)P
				WHERE 
					T.CD_GRP_PRT=@CD_PRT 
					AND T.FLAG_RESSUPRIMENTO_CAIXA_FECHADA=1; 


				INSERT INTO EST_PROD_TRANSF_NECESSIDADE(CD_FILIAL,CD_PROD,EMAX,QMIN,QTDE_MEDIAF,
													QT_EST_RESSUP_ORIG,QT_EST_RESSUP,
													VLR_PROD,VLR_CUSTO_MD,CD_GRP_RES,QTDE_EST,
													QT_EST_RESSUP_INI,CD_SIGLA,ESEGCAD,EMAXCAD,
													PARAM_ESPECIAL,CD_GRP_PRT,QT_UNI_RESSUPRIMENTO,FLAG_RESSUPRIMENTO_CAIXA_FECHADA,
													PERC_RATEIO,MEDIAF_SOMA,QTDE_DEPOS_SOMA,QTDE_FILIAIS_SOMA,
													FLAG_RATEIO,FLAG_AJUSTE_RATEIO,PERC_DESC,QT_EST_LJ,QT_PEND_ENT_LJ)

				SELECT A.CD_FILIAL,A.CD_PROD,A.EMAX,A.QMIN,A.QTDE_MEDIAF,
						0 QT_EST_RESSUP_ORIG,A.QT_EST_RESSUP,
						A.VLR_PROD,A.VLR_CUSTO_MD,A.CD_GRP_RES,A.QTDE_EST,
						A.QT_EST_RESSUP_INI,A.CD_SIGLA,A.ESEGCAD,A.EMAXCAD,
						A.PARAM_ESPECIAL,A.CD_GRP_PRT,A.QT_UNI_RESSUPRIMENTO,A.FLAG_RESSUPRIMENTO_CAIXA_FECHADA,
						A.PERC_RATEIO,A.MEDIAF_SOMA,A.QTDE_DEPOS_SOMA,A.QTDE_FILIAIS_SOMA,
						A.FLAG_RATEIO,A.FLAG_AJUSTE_RATEIO,A.PERC_DESC,A.QT_EST_LJ,A.QT_PEND_ENT_LJ
				FROM
					EST_PROD_TRANSF_NECESSIDADE_FUTURA A
					LEFT JOIN EST_PROD_TRANSF_NECESSIDADE B ON 
					A.CD_FILIAL = B.CD_FILIAL AND
					A.CD_PROD = B.CD_PROD
				WHERE 
					B.CD_PROD IS NULL
					AND A.CD_GRP_PRT=@CD_PRT
					AND A.FLAG_RESSUPRIMENTO_CAIXA_FECHADA=1
					AND A.SUB_TOTAL<=@CORTE; 
				  
				FETCH NEXT FROM cCapOcioso INTO @CD_PRT,@QTDE, @LIMITE
			  END

		PRINT 'Concludo.'
		CLOSE cCapOcioso
		DEALLOCATE cCapOcioso

/**************************************************************************************************************************************/
--Fracionado
/**************************************************************************************************************************************/

 		DECLARE cCapOcioso CURSOR  FAST_FORWARD READ_ONLY for
		SELECT 
			A.CD_GRP_PRT,
			A.QTDE_FR,
			B.LIM_FR 
		FROM
			(SELECT 
					CD_GRP_PRT, 
					SUM (CASE WHEN FLAG_RESSUPRIMENTO_CAIXA_FECHADA = 0 THEN 0 ELSE QT_EST_RESSUP END) QTDE_CX,
					SUM (CASE WHEN FLAG_RESSUPRIMENTO_CAIXA_FECHADA = 1 THEN 0 ELSE QT_EST_RESSUP END) QTDE_FR
				FROM 
					EST_PROD_TRANSF_ANALISE_LIMIT
				WHERE OCIOSO=1
				GROUP BY CD_GRP_PRT ) A
				INNER JOIN (SELECT 
							CD_GRP_PRT, 
							MAX(QTDE_CX_FECHADA) LIM_CX,
							MAX(QTDE_FRACIONADO) LIM_FR
						FROM 
							EST_PROD_TRANSF_ANALISE_LIMIT
						WHERE OCIOSO=1
						GROUP BY CD_GRP_PRT ) B ON
			A.CD_GRP_PRT = B.CD_GRP_PRT
		WHERE
			 QTDE_FR < LIM_FR;  

		OPEN cCapOcioso
		FETCH NEXT FROM cCapOcioso INTO @CD_PRT,@QTDE, @LIMITE

			WHILE @@FETCH_STATUS=0
			  BEGIN
		   
				if @LIMITE> (SELECT 
									SUM(QT_EST_RESSUP) + @QTDE
								FROM 
									EST_PROD_TRANSF_NECESSIDADE_FUTURA
								WHERE 
									CD_GRP_PRT=@CD_PRT
									AND FLAG_RESSUPRIMENTO_CAIXA_FECHADA=1)
				begin
					--PRINT 'Implementa tudo'
					SET @CORTE=@LIMITE+1;
				END
				ELSE
				BEGIN 
				--	PRINT 'Rateio' 
					SET @CORTE=@LIMITE-@QTDE;
				END
		 
				UPDATE T 
				SET
					SUB_TOTAL= ISNULL(QTDE,0)+ QT_EST_RESSUP 
				FROM
					EST_PROD_TRANSF_NECESSIDADE_FUTURA T
					CROSS APPLY (SELECT 
									SUM(R.QT_EST_RESSUP) QTDE
								FROM EST_PROD_TRANSF_NECESSIDADE_FUTURA R
								WHERE 
								R.POSICAO < T.POSICAO
								AND R.CD_GRP_PRT=T.CD_GRP_PRT
								AND R.FLAG_RESSUPRIMENTO_CAIXA_FECHADA=1)P
				WHERE 
					T.CD_GRP_PRT=@CD_PRT 
					AND T.FLAG_RESSUPRIMENTO_CAIXA_FECHADA=1; 


				INSERT INTO EST_PROD_TRANSF_NECESSIDADE(CD_FILIAL,CD_PROD,EMAX,QMIN,QTDE_MEDIAF,
													QT_EST_RESSUP_ORIG,QT_EST_RESSUP,
													VLR_PROD,VLR_CUSTO_MD,CD_GRP_RES,QTDE_EST,
													QT_EST_RESSUP_INI,CD_SIGLA,ESEGCAD,EMAXCAD,
													PARAM_ESPECIAL,CD_GRP_PRT,QT_UNI_RESSUPRIMENTO,FLAG_RESSUPRIMENTO_CAIXA_FECHADA,
													PERC_RATEIO,MEDIAF_SOMA,QTDE_DEPOS_SOMA,QTDE_FILIAIS_SOMA,
													FLAG_RATEIO,FLAG_AJUSTE_RATEIO,PERC_DESC,QT_EST_LJ,QT_PEND_ENT_LJ)

				SELECT A.CD_FILIAL,A.CD_PROD,A.EMAX,A.QMIN,A.QTDE_MEDIAF,
						A.QT_EST_RESSUP_ORIG,A.QT_EST_RESSUP,
						A.VLR_PROD,A.VLR_CUSTO_MD,A.CD_GRP_RES,A.QTDE_EST,
						A.QT_EST_RESSUP_INI,A.CD_SIGLA,A.ESEGCAD,A.EMAXCAD,
						A.PARAM_ESPECIAL,A.CD_GRP_PRT,A.QT_UNI_RESSUPRIMENTO,A.FLAG_RESSUPRIMENTO_CAIXA_FECHADA,
						A.PERC_RATEIO,A.MEDIAF_SOMA,A.QTDE_DEPOS_SOMA,A.QTDE_FILIAIS_SOMA,
						A.FLAG_RATEIO,A.FLAG_AJUSTE_RATEIO,A.PERC_DESC,A.QT_EST_LJ,A.QT_PEND_ENT_LJ
				FROM
					EST_PROD_TRANSF_NECESSIDADE_FUTURA A
					LEFT JOIN EST_PROD_TRANSF_NECESSIDADE B ON 
					A.CD_FILIAL = B.CD_FILIAL AND
					A.CD_PROD = B.CD_PROD
				WHERE 
					B.CD_PROD IS NULL
					AND A.CD_GRP_PRT=@CD_PRT
					AND A.FLAG_RESSUPRIMENTO_CAIXA_FECHADA=1
					AND A.SUB_TOTAL<=@CORTE; 
		 
					FETCH NEXT FROM cCapOcioso INTO @CD_PRT,@QTDE, @LIMITE
			  END

		PRINT 'Concludo.'
		CLOSE cCapOcioso
		DEALLOCATE cCapOcioso

	END 

/*******************************************************************************************************/
/******************************************************************************************************/ 
 

/*******************************************************************************************************/
-- RATEIO LIMITADOR POR UNIDADE
/*******************************************************************************************************/
	
	DECLARE  @SubTot MONEY, @UltSubTot MONEY; 

	--Limitador por unidade fracionado....
	IF EXISTS (SELECT TOP 1 * 
				FROM EST_PROD_TRANSF_ANALISE_LIMIT
					where TP_LIMITADOR=1 and FLAG_RESSUPRIMENTO_CAIXA_FECHADA=0 )
	BEGIN
		
		PRINT 'Realizando limite capacidade CD Unidades Fracionado (' + CONVERT(VARCHAR(12), GETDATE(), 114) + ')'; 

		UPDATE a SET  a.QT_EST_RESSUP =0, QT_SOL_PROD=0
		FROM EST_PROD_TRANSF_ANALISE_LIMIT a ;

		INSERT INTO EST_PROD_TRANSF_IT_LIMITE (CD_EMP,CD_FILIAL,CD_PROD,QT_EST_RESSUP)
		SELECT
			A.CD_EMP,A.CD_FILIAL,A.CD_PROD,0
		FROM EST_PROD_TRANSF_ANALISE_LIMIT A 
		WHERE  FLAG_RESSUPRIMENTO_CAIXA_FECHADA=0;

		set @SubTot =0;
		set @UltSubTot =0;

		DECLARE cLimite CURSOR FAST_FORWARD FOR 
		SELECT 
			CD_GRP_PRT
		FROM 
			EST_PROD_TRANSF_ANALISE_LIMIT 
		GROUP BY CD_GRP_PRT;

		OPEN cLimite
		FETCH NEXT FROM cLimite INTO @CD_PRT; 
		WHILE @@FETCH_STATUS=0
			begin
				
				print 'Realizando rateio fracionados prateleira  ' + convert(varchar,@CD_PRT) + ' ('+ CONVERT(VARCHAR(12), GETDATE(), 114) + ')'; 
				--Total por produto
				UPDATE A
				SET
					QT_SOL_PROD	= B.QTD_PROD,
					RATEIO		= CASE WHEN (a.QT_EST	+ a.QT_EST_RESSUP	+ a.QT_UNI_RESSUPRIMENTO) >= A.QEMAX THEN 0
									ELSE 1 END
				FROM
					EST_PROD_TRANSF_ANALISE_LIMIT A
					INNER JOIN (SELECT 
									CD_EMP,CD_PROD,SUM(QT_EST_RESSUP) QTD_PROD
								FROM EST_PROD_TRANSF_ANALISE_LIMIT 
								WHERE CD_GRP_PRT=@CD_PRT
								GROUP BY 
										CD_EMP,
										CD_PROD) b on 
					a.CD_EMP	= b.CD_EMP and 
					a.CD_PROD	= b.CD_PROD
				WHERE 
					a.CD_GRP_PRT=@CD_PRT;

				UPDATE a
				SET  
					a.QT_EST_RESSUP = a.QT_EST_RESSUP+ a.QT_UNI_RESSUPRIMENTO
				FROM 
					EST_PROD_TRANSF_ANALISE_LIMIT a  
				WHERE 
					a.CD_GRP_PRT=@CD_PRT
					AND (a.QT_EST+a.QT_EST_RESSUP+ a.QT_UNI_RESSUPRIMENTO) <= A.QEMAX
					AND (a.QT_EST_RESSUP+ a.QT_UNI_RESSUPRIMENTO+A.QT_SOL_PROD)<=A.QT_EST_CD
					AND A.RATEIO=1; 
				
				PRINT 'Posicionado os produtos (' + CONVERT(VARCHAR(12), GETDATE(), 114) + ')'; 

				update a
				set 
					POSICAO=  New_position
				FROM 
					EST_PROD_TRANSF_ANALISE_LIMIT a
					inner join (select 
									a.cd_emp,
									a.cd_prod,
									a.cd_filial,
										ROW_NUMBER() OVER (PARTITION BY a.CD_GRP_PRT   ORDER BY  a.CD_GRP_PRT, 
											CONVERT(MONEY, (a.QT_EST  + a.QT_EST_RESSUP/ 
											CASE WHEN a.MEDIAF > 0 THEN a.MEDIAF
										ELSE 0.001 END) *30.000) ) New_position
								FROM EST_PROD_TRANSF_ANALISE_LIMIT A
								WHERE	
									A.CD_GRP_PRT=@CD_PRT
									and a.FLAG_RESSUPRIMENTO_CAIXA_FECHADA=0
									AND A.RATEIO=1 ) b on
					a.cd_emp	=b.cd_emp and
					a.cd_prod	=b.cd_prod and
					a.cd_filial	=b.cd_filial 
				WHERE 
					a.CD_GRP_PRT=@CD_PRT
					AND a.FLAG_RESSUPRIMENTO_CAIXA_FECHADA=0
					--AND a.QT_EST_RESSUP <= A.QEMAX;

				UPDATE A
				SET
					POSICAO = (SELECT COUNT(*)
										FROM EST_PROD_TRANSF_ANALISE_LIMIT
										 WHERE  CD_GRP_PRT=@CD_PRT
												and FLAG_RESSUPRIMENTO_CAIXA_FECHADA=0) + POSICAO
				FROM
					EST_PROD_TRANSF_ANALISE_LIMIT A
				WHERE
					 a.CD_GRP_PRT=@CD_PRT
					 and a.FLAG_RESSUPRIMENTO_CAIXA_FECHADA=0;


				PRINT 'Atualiza o sub totais dos produtos ' + CONVERT(VARCHAR(12), GETDATE(), 108); 
				UPDATE T
				SET
					SUB_TOT= @SubTot+ ISNULL(QTDE,0)+ QT_EST_RESSUP
				FROM
					EST_PROD_TRANSF_ANALISE_LIMIT T
					CROSS APPLY (SELECT SUM(CASE WHEN ROUND((R.QEMAX-R.QT_EST)/ R.QT_UNI_RESSUPRIMENTO,0)>0 THEN
											R.QT_UNI_RESSUPRIMENTO ELSE 0 END) QTDE
									FROM EST_PROD_TRANSF_ANALISE_LIMIT R
									WHERE 
										R.POSICAO < T.POSICAO
										AND R.CD_GRP_PRT=T.CD_GRP_PRT
										AND R.FLAG_RESSUPRIMENTO_CAIXA_FECHADA=0
										AND R.RATEIO=1 )P
				WHERE 
					T.FLAG_RESSUPRIMENTO_CAIXA_FECHADA=0 
					AND T.CD_GRP_PRT=@CD_PRT
					AND T.RATEIO=1;


				if (SELECT  count(*)
						FROM
							EST_PROD_TRANSF_ANALISE_LIMIT
						WHERE  CD_GRP_PRT = @CD_PRT
							   AND FLAG_RESSUPRIMENTO_CAIXA_FECHADA = 0
							   AND RATEIO = 1)=1
				begin 
						
						update EST_PROD_TRANSF_ANALISE_LIMIT
						set
							rateio =0
						WHERE  CD_GRP_PRT = @CD_PRT
							   AND FLAG_RESSUPRIMENTO_CAIXA_FECHADA = 0
							   AND RATEIO = 1
				end;	


				if exists(SELECT TOP 1 CD_EMP FROM EST_PROD_TRANSF_ANALISE_LIMIT 
									WHERE 
										SUB_TOT>QTDE_FRACIONADO
										and CD_GRP_PRT=@CD_PRT
										and FLAG_RESSUPRIMENTO_CAIXA_FECHADA=0 
										AND RATEIO=1) OR NOT EXISTS (SELECT TOP 1 CD_EMP FROM EST_PROD_TRANSF_ANALISE_LIMIT 
																						WHERE 
																							CD_GRP_PRT=@CD_PRT
																							and FLAG_RESSUPRIMENTO_CAIXA_FECHADA=0
																							AND RATEIO=1)
																		OR NOT EXISTS (SELECT TOP 1 CD_EMP FROM EST_PROD_TRANSF_ANALISE_LIMIT 
																						WHERE 
																							CD_GRP_PRT=@CD_PRT
																							and FLAG_RESSUPRIMENTO_CAIXA_FECHADA=0)
					begin
						update i
						set							 
							i.QT_EST_RESSUP = A.QT_EST_RESSUP 
					 	FROM
							EST_PROD_TRANSF_IT_LIMITE i
							INNER JOIN EST_PROD_TRANSF_ANALISE_LIMIT A ON 
							I.CD_EMP=A.CD_EMP AND
							I.CD_FILIAL=A.CD_FILIAL AND
							I.CD_PROD=A.CD_PROD
						WHERE 
							A.CD_GRP_PRT=@CD_PRT
							AND A.SUB_TOT<=QTDE_FRACIONADO
							and A.FLAG_RESSUPRIMENTO_CAIXA_FECHADA=0
							AND A.RATEIO=1;

						set @SubTot =0;
						FETCH NEXT FROM cLimite INTO @CD_PRT;  
					end
				else
					begin
					
						update i
						set							 
							i.QT_EST_RESSUP = CASE WHEN (i.QT_EST_RESSUP+ a.QT_UNI_RESSUPRIMENTO)>A.QEMAX THEN
													A.QEMAX
													ELSE (i.QT_EST_RESSUP+ a.QT_UNI_RESSUPRIMENTO) END
						FROM
							EST_PROD_TRANSF_IT_LIMITE i
							INNER JOIN EST_PROD_TRANSF_ANALISE_LIMIT A ON 
							I.CD_EMP=A.CD_EMP AND
							I.CD_FILIAL=A.CD_FILIAL AND
							I.CD_PROD=A.CD_PROD
						WHERE 
							A.CD_GRP_PRT=@CD_PRT
							and A.FLAG_RESSUPRIMENTO_CAIXA_FECHADA=0
							AND (CASE WHEN (i.QT_EST_RESSUP+ a.QT_UNI_RESSUPRIMENTO)>A.QEMAX THEN
													A.QEMAX
													ELSE (i.QT_EST_RESSUP+ a.QT_UNI_RESSUPRIMENTO) END +A.QT_SOL_PROD) <=A.QT_EST_CD;
													 
						PRINT 'Carrega o subtotal geral ' + CONVERT(VARCHAR(12), GETDATE(), 108) ; 
						set @SubTot = ISNULL((SELECT SUM(I.QT_EST_RESSUP)
													FROM
														EST_PROD_TRANSF_IT_LIMITE I
														INNER JOIN EST_PROD_TRANSF_ANALISE_LIMIT A ON 
														I.CD_EMP=A.CD_EMP AND
														I.CD_FILIAL=A.CD_FILIAL AND
														I.CD_PROD=A.CD_PROD
													WHERE 
														A.CD_GRP_PRT=@CD_PRT
														and A.FLAG_RESSUPRIMENTO_CAIXA_FECHADA=0),0);
						
						if @SubTot =@UltSubTot
						begin
							FETCH NEXT FROM cLimite INTO @CD_PRT;
						end

					    SET @UltSubTot = @SubTot;												
														 
					end 
				end  


		CLOSE cLimite;
		DEALLOCATE cLimite 

		/*******************************************************************************/
		--Limita as quantidades 
		UPDATE F
		SET
			QT_EST_RESSUP= ISNULL(l.QT_EST_RESSUP,0)
		FROM
			EST_PROD_TRANSF_NECESSIDADE f 
			JOIN EST_PROD_TRANSF_IT_LIMITE L ON
			F.CD_FILIAL  =L.CD_FILIAL AND
			F.CD_PROD	 =L.CD_PROD; 
	END
	 

	truncate table EST_PROD_TRANSF_IT_LIMITE;
	--Limitador por unidade caixa....
	IF EXISTS (SELECT TOP 1 * 
				FROM EST_PROD_TRANSF_ANALISE_LIMIT
					where TP_LIMITADOR=1 and FLAG_RESSUPRIMENTO_CAIXA_FECHADA=1 )
	BEGIN
		
		PRINT 'Realizando limite capacidade CD Unidades Caixa ' + CONVERT(VARCHAR(12), GETDATE(), 108) ; 
		
		UPDATE a SET  a.QT_EST_RESSUP =0
		FROM EST_PROD_TRANSF_ANALISE_LIMIT a ;
		
		INSERT INTO EST_PROD_TRANSF_IT_LIMITE (CD_EMP,CD_FILIAL,CD_PROD,QT_EST_RESSUP)
		SELECT
			A.CD_EMP,A.CD_FILIAL,A.CD_PROD,0
		FROM EST_PROD_TRANSF_ANALISE_LIMIT A
		WHERE  FLAG_RESSUPRIMENTO_CAIXA_FECHADA=1;

		set @SubTot =0;

		DECLARE cLimite CURSOR FAST_FORWARD FOR 
		SELECT 
			CD_GRP_PRT
		FROM 
			EST_PROD_TRANSF_ANALISE_LIMIT 
		GROUP BY CD_GRP_PRT;

		OPEN cLimite
		FETCH NEXT FROM cLimite INTO @CD_PRT; 
		WHILE @@FETCH_STATUS=0
			begin
				
				print 'Realizando rateio caixa prateleira  ' + convert(varchar,@CD_PRT) + ' - ' + CONVERT(VARCHAR(12), GETDATE(), 108)  
				--Total por produto
				UPDATE A
				SET
					QT_SOL_PROD= B.QTD_PROD,
					RATEIO	= CASE WHEN (a.QT_EST + a.QT_EST_RESSUP+ a.QT_UNI_RESSUPRIMENTO) >= A.QEMAX THEN 0
								ELSE 1 END
				FROM
					EST_PROD_TRANSF_ANALISE_LIMIT A
					INNER JOIN (SELECT 
									CD_EMP,CD_PROD,SUM(QT_EST_RESSUP) QTD_PROD
								FROM EST_PROD_TRANSF_ANALISE_LIMIT 
								WHERE CD_GRP_PRT=@CD_PRT
								GROUP BY 
										CD_EMP,
										CD_PROD) b on 
					a.CD_EMP	= b.CD_EMP and 
					a.CD_PROD	= b.CD_PROD
				WHERE 
					a.CD_GRP_PRT=@CD_PRT;

				UPDATE a
				SET  
					a.QT_EST_RESSUP =  a.QT_EST_RESSUP+ a.QT_UNI_RESSUPRIMENTO
				FROM 
					EST_PROD_TRANSF_ANALISE_LIMIT a  
				WHERE 
					a.CD_GRP_PRT=@CD_PRT
					AND (a.QT_EST	+ a.QT_EST_RESSUP + a.QT_UNI_RESSUPRIMENTO) <= A.QEMAX
					AND (a.QT_EST_RESSUP+ a.QT_UNI_RESSUPRIMENTO+A.QT_SOL_PROD)<=A.QT_EST_CD
					AND A.RATEIO=1;   
				
				PRINT 'Posicionado os produtos ' + CONVERT(VARCHAR(12), GETDATE(), 108) 
				update a
				set 
					POSICAO=  New_position
				FROM 
					EST_PROD_TRANSF_ANALISE_LIMIT a
					inner join (select 
									a.cd_emp,
									a.cd_prod,
									a.cd_filial,
									
									ROW_NUMBER() OVER (PARTITION BY a.CD_GRP_PRT   ORDER BY  a.CD_GRP_PRT, 
											CONVERT(MONEY, (a.QT_EST  + a.QT_EST_RESSUP/ 
											CASE WHEN a.MEDIAF > 0 THEN a.MEDIAF
										ELSE 0.001 END) *30.000) ) New_position

								from EST_PROD_TRANSF_ANALISE_LIMIT a
								where	a.CD_GRP_PRT=@CD_PRT
									and a.FLAG_RESSUPRIMENTO_CAIXA_FECHADA=1
									AND A.RATEIO=1) b on
					a.cd_emp	=b.cd_emp and
					a.cd_prod	=b.cd_prod and
					a.cd_filial	=b.cd_filial 
				WHERE 
					a.CD_GRP_PRT=@CD_PRT
					AND A.RATEIO=1
					and a.FLAG_RESSUPRIMENTO_CAIXA_FECHADA=1;

				UPDATE A
				SET
					POSICAO = (SELECT COUNT(*)
										FROM EST_PROD_TRANSF_ANALISE_LIMIT
										 WHERE CD_GRP_PRT=@CD_PRT) + POSICAO
				FROM
					EST_PROD_TRANSF_ANALISE_LIMIT A
				WHERE
					 A.RATEIO=0
					 AND a.CD_GRP_PRT=@CD_PRT
					 and a.FLAG_RESSUPRIMENTO_CAIXA_FECHADA=1;
					 
				PRINT 'Atualiza o sub totais dos produtos ' + CONVERT(VARCHAR(12), GETDATE(), 108)

				UPDATE T
				SET	   --
					SUB_TOT= @SubTot+ ISNULL(QTDE,0) + QT_EST_RESSUP
				FROM
					EST_PROD_TRANSF_ANALISE_LIMIT T
					CROSS APPLY (SELECT 
										SUM(
											CASE WHEN ROUND((R.QEMAX-R.QT_EST)/ R.QT_UNI_RESSUPRIMENTO,0)>0 THEN
											R.QT_UNI_RESSUPRIMENTO ELSE 0 END   
										) QTDE
									FROM EST_PROD_TRANSF_ANALISE_LIMIT R
									WHERE 
										R.POSICAO < T.POSICAO
										AND R.CD_GRP_PRT=T.CD_GRP_PRT
										AND R.FLAG_RESSUPRIMENTO_CAIXA_FECHADA=1
										AND R.RATEIO=1
										)P
				WHERE 
					T.FLAG_RESSUPRIMENTO_CAIXA_FECHADA=1
					AND T.CD_GRP_PRT=@CD_PRT
					AND T.RATEIO=1; 
				

				IF EXISTS(SELECT TOP 1 CD_EMP FROM EST_PROD_TRANSF_ANALISE_LIMIT -- Atingiu o limite
									WHERE 
										SUB_TOT>QTDE_CX_FECHADA
										AND CD_GRP_PRT=@CD_PRT
										AND FLAG_RESSUPRIMENTO_CAIXA_FECHADA=1
										AND RATEIO=1 ) 
								OR NOT EXISTS -- Ou nao exista produtos caixa fechada
								(SELECT TOP 1 CD_EMP FROM EST_PROD_TRANSF_ANALISE_LIMIT 
											WHERE 
												CD_GRP_PRT=@CD_PRT
												and FLAG_RESSUPRIMENTO_CAIXA_FECHADA=1)
								OR NOT EXISTS -- Ou nao exista produtos para rateio
								(SELECT TOP 1 CD_EMP FROM EST_PROD_TRANSF_ANALISE_LIMIT 
											WHERE 
												CD_GRP_PRT=@CD_PRT
												and FLAG_RESSUPRIMENTO_CAIXA_FECHADA=1
												AND RATEIO=1)
					begin
						
						update i
						set							 
							i.QT_EST_RESSUP = A.QT_EST_RESSUP 
					 	FROM
							EST_PROD_TRANSF_IT_LIMITE i
							INNER JOIN EST_PROD_TRANSF_ANALISE_LIMIT A ON 
							I.CD_EMP	=A.CD_EMP AND
							I.CD_FILIAL	=A.CD_FILIAL AND
							I.CD_PROD	=A.CD_PROD
						WHERE 
							A.CD_GRP_PRT=@CD_PRT
							AND A.SUB_TOT<=QTDE_CX_FECHADA
							AND A.RATEIO=1
							and A.FLAG_RESSUPRIMENTO_CAIXA_FECHADA=1 ;

						set @SubTot =0;
						FETCH NEXT FROM cLimite INTO @CD_PRT;  
					end
				else
					begin
					
						update i
						set							 
							i.QT_EST_RESSUP =a.QT_EST_RESSUP --CASE WHEN (a.QT_EST_RESSUP+ a.QT_UNI_RESSUPRIMENTO)>A.QEMAX THEN
											--			A.QEMAX
											--		ELSE (A.QT_EST_RESSUP+ a.QT_UNI_RESSUPRIMENTO) END
							 
						FROM
							EST_PROD_TRANSF_IT_LIMITE i
							INNER JOIN EST_PROD_TRANSF_ANALISE_LIMIT A ON 
							I.CD_EMP=A.CD_EMP AND
							I.CD_FILIAL=A.CD_FILIAL AND
							I.CD_PROD=A.CD_PROD
						WHERE 
							A.CD_GRP_PRT=@CD_PRT
							AND A.FLAG_RESSUPRIMENTO_CAIXA_FECHADA=1
							AND A.RATEIO=1
							AND (CASE WHEN (A.QT_EST_RESSUP+ a.QT_UNI_RESSUPRIMENTO)>A.QEMAX THEN
									   A.QEMAX
								    ELSE (A.QT_EST_RESSUP+ a.QT_UNI_RESSUPRIMENTO) END + A.QT_SOL_PROD) <=A.QT_EST_CD;
						set @RegAfetado=@@rowcount; 
							 
						PRINT 'Carrega o subtotal geral ' + CONVERT(VARCHAR(12), GETDATE(), 108) 
						set @SubTot = ISNULL((select sum(i.QT_EST_RESSUP)
										FROM
											EST_PROD_TRANSF_IT_LIMITE i
											INNER JOIN EST_PROD_TRANSF_ANALISE_LIMIT A ON 
											I.CD_EMP=A.CD_EMP AND
											I.CD_FILIAL=A.CD_FILIAL AND
											I.CD_PROD=A.CD_PROD
										WHERE 
											A.CD_GRP_PRT=@CD_PRT
											and A.FLAG_RESSUPRIMENTO_CAIXA_FECHADA=1),0);  
						if @RegAfetado =0
						begin
							PRINT 'Sem produtos para atender.. Prat.: '+ CONVERT(VARCHAR,@CD_PRT) + ' ' + CONVERT(VARCHAR(12), GETDATE(), 108) 
							FETCH NEXT FROM cLimite INTO @CD_PRT;  
						end
						 
					
					end 
				end 
				  
		CLOSE cLimite;
		DEALLOCATE cLimite;  

		/*******************************************************************************/		
		PRINT 'Limita as quantidades '

		UPDATE F
		SET
			QT_EST_RESSUP= ISNULL(l.QT_EST_RESSUP,0)
		FROM
			EST_PROD_TRANSF_NECESSIDADE f 
			JOIN EST_PROD_TRANSF_IT_LIMITE L ON
			F.CD_FILIAL  =L.CD_FILIAL AND
			F.CD_PROD	 =L.CD_PROD;

	END

	
/**********************************************************************************************************/
/**********************************************************************************************************/

/*******************************************************************************************************/
--										Carrega o resultado Simulado..
/*******************************************************************************************************/
	IF @SIMULACAO=1
	BEGIN
		DELETE FROM 
			EST_PROD_TRANSF_IT_SIMULADO
		WHERE
			CD_EMP=@CD_EMP
			AND DT_TRANSF=@DT_REF 
			AND CD_FILIAL=@CD_DEPOSITO;

		INSERT INTO EST_PROD_TRANSF_IT_SIMULADO (  DT_TRANSF
														 , CD_EMP
														 , CD_FILIAL
														 , CD_FIL_DEST
														 , CD_GRP_PRT
														 , CD_PROD
														 , QT_SOL_ORIG
														 , QT_NEC_LOJA
														 , QT_SOL
														 , QT_PENDENTE
														 , VLR_CUSTO
														 , QT_MEDIAF
														 , QT_EMAX
														 , QT_ESEG
														 , FLAG_RATEIO
														 , QT_EST_DEPO_RES
														 , PERC_RATEIO
														 , PERC_DESC
														 , QT_EST
														 , QT_PEND_ENT
														 , EMAX_RES
														 , ESEG_RES
														 , VLR_CUSTO_MD
														 , RESSUP_CX_FECHADA
														 , QT_UNI_RESSUPRIMENTO
														 , DT_CAD
													)
       SELECT
              @DT_REF DT_TRANSF
            , @CD_EMP CD_EMP
            , @CD_DEPOSITO CD_FILIAL
            , N.CD_FILIAL CD_FIL_DEST
            , ISNULL(N.CD_GRP_PRT, 0) CD_GRP_PRT
            , N.CD_PROD
            , CASE WHEN S.CD_PROD > 0 THEN ISNULL(n.QT_EST_RESSUP_PICKING,0)	ELSE 0 END QT_EST_RESSUP_PICKING  
			, CASE WHEN S.CD_PROD > 0 THEN ISNULL(n.QT_EST_RESSUP_ORIG,0) 		ELSE 0 END QT_EST_RESSUP_ORIG  
            , CASE WHEN S.CD_PROD > 0 THEN ISNULL(n.QT_EST_RESSUP,0)			ELSE 0 END QT_SOL
            , 0 QT_PENDENTE
            , N.VLR_PROD
            , N.QTDE_MEDIAF QT_MEDIAF
            , N.EMAXCAD QT_EMAX
            , N.ESEGCAD QT_ESEG
            , N.FLAG_RATEIO
            , isnull(N.QTDE_DEPOS_SOMA, 0) QT_EST_DEPO_RES
            , N.PERC_RATEIO
            , COALESCE(N.PERC_DESC, 0)
            , N.QTDE_EST QT_EST
            , N.QT_PEND_ENT_LJ
            , N.EMAX EMAX_RES
            , N.QMIN ESEG_RES
            , N.VLR_CUSTO_MD
            , N.FLAG_RESSUPRIMENTO_CAIXA_FECHADA RESSUP_CX_FECHADA
            , N.QT_UNI_RESSUPRIMENTO
            , GETDATE() DT_CAD
       FROM
            EST_PROD_TRANSF_NECESSIDADE N
            LEFT JOIN EST_PROD_TRANSF_CONSOLIDADO s ON 
			n.CD_PROD = s.CD_PROD;
			 
		--Pendentes de outros dias
		UPDATE S
		SET
			  QT_PENDENTE = P.QT_PENDENTE
		FROM EST_PROD_TRANSF_IT_SIMULADO S
			 INNER JOIN  ( SELECT
									   I.CD_PROD
									 , T.CD_FIL_DEST
									 , SUM(i.QT_SOL) QT_PENDENTE
								FROM
									 EST_PROD_TRANSF T
									 INNER JOIN EST_PROD_TRANSF_IT I ON T.CD_EMP = I.CD_EMP
																		AND T.CD_FILIAL = I.CD_FILIAL
																		AND T.CD_CTR = I.CD_CTR
								WHERE T.CD_EMP = 1
									  AND t.STS_TRANSF IN(0, 6)
									 AND T.CD_EMP = @CD_EMP
									 AND T.CD_FILIAL = @CD_DEPOSITO
								GROUP BY
										 T.CD_FIL_DEST
									   , i.CD_PROD
							) P ON S.CD_PROD = P.CD_PROD
								   AND S.CD_FIL_DEST = P.CD_FIL_DEST
							WHERE
								  S.DT_TRANSF = @DT_REF
								  AND S.CD_FILIAL = @CD_DEPOSITO;

		INSERT INTO EST_PROD_TRANSF_IT_SIMULADO (  DT_TRANSF
														 , CD_EMP
														 , CD_FILIAL
														 , CD_FIL_DEST
														 , CD_GRP_PRT
														 , CD_PROD
														 , QT_SOL_ORIG
														 , QT_NEC_LOJA
														 , QT_SOL
														 , QT_PENDENTE
														 , VLR_CUSTO
														 , QT_MEDIAF
														 , QT_EMAX
														 , QT_ESEG
														 , FLAG_RATEIO
														 , QT_EST_DEPO_RES
														 , PERC_RATEIO
														 , PERC_DESC
														 , QT_EST
														 , QT_PEND_ENT
														 , EMAX_RES
														 , ESEG_RES
														 , VLR_CUSTO_MD
														 , RESSUP_CX_FECHADA
														 , QT_UNI_RESSUPRIMENTO
														 , DT_CAD
													)
       SELECT
              @DT_REF DT_TRANSF
            , @CD_EMP CD_EMP
            , @CD_DEPOSITO CD_FILIAL
            , T.CD_FIL_DEST CD_FIL_DEST
            , ISNULL(P.CD_GRP_PRT, 0) CD_GRP_PRT
            , i.CD_PROD
            , 0 QT_SOL
			, 0 QT_NEC_LOJA
            , 0 QT_SOL
            , SUM(i.QT_SOL) QT_PENDENTE
            , AVG(i.VLR_CUSTO)
            , AVG(i.QT_MEDIAF) QT_MEDIAF
            , AVG(i.QT_EMAX) QT_EMAX
            , AVG(i.QT_EMAX) QT_ESEG
            , 0 FLAG_RATEIO
            , AVG(isnull(i.QT_EST_DEPO_RES, 0)) QT_EST_DEPO_RES
            , AVG(i.PERC_RATEIO)
            , AVG(i.PERC_DESC)
            , AVG(i.QT_EST)
            , AVG(i.QT_PEND_ENT)
            , AVG(i.EMAX_RES)
            , AVG(i.ESEG_RES)
            , AVG(i.VLR_CUSTO_MD)
            , 0 FLAG_CAIXA_FECHADA
            , AVG(i.QT_UNI_RESSUPRIMENTO)
            , GETDATE()
       FROM
            EST_PROD_TRANSF T
            INNER JOIN EST_PROD_TRANSF_IT I ON T.CD_EMP = I.CD_EMP
                                               AND T.CD_FILIAL = I.CD_FILIAL
                                               AND T.CD_CTR = I.CD_CTR
            INNER JOIN EST_PROD_CPL C ON I.CD_EMP = C.CD_EMP
                                         AND I.CD_FILIAL = C.CD_FILIAL
                                         AND I.CD_PROD = C.CD_PROD
            LEFT JOIN EST_PROD_PRT_GRP_RESSUPRIMENTO_CPL P ON C.PRAT = P.CD_PRT
            LEFT JOIN EST_PROD_TRANSF_IT_SIMULADO S ON I.CD_EMP = S.CD_EMP
                                                       AND I.CD_FILIAL = S.CD_FILIAL
                                                       AND I.CD_PROD = S.CD_PROD
                                                       AND S.CD_FIL_DEST = T.CD_FIL_DEST
                                                       AND S.DT_TRANSF = @DT_REF
       WHERE T.CD_EMP = 1
             AND T.CD_FILIAL = @CD_DEPOSITO
             AND S.CD_PROD IS NULL
             AND t.STS_TRANSF IN(0, 6)
       GROUP BY
                T.CD_FIL_DEST
              , ISNULL(P.CD_GRP_PRT, 0)
              , i.CD_PROD;
	END
	DELETE FROM EST_PROD_TRANSF_NECESSIDADE
	WHERE QT_EST_RESSUP <1;